<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Informes</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>informe" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>informe" class="link">Informe de compras</a></li>
            <li class="breadcrumb-item active">Todas las compras</li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body p-b-0">
                <div class="message-box contact-box">
                    <div class="d-flex align-items-center mb-3">
                        <!-- Botón de exportar alineado a la derecha, sin título de filtros -->
                        <div class="ml-auto">
                            <div class="btn-group">
                            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-download mr-1"></i> Exportar
                            </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a class="dropdown-item" href="javascript:void();" id="excel"><i class="far fa-file-excel text-success mr-2"></i>A Excel</a>
                                    <a class="dropdown-item" href="javascript:void();" id="pdf"><i class="far fa-file-pdf text-danger mr-2"></i>A PDF</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row floating-labels">
                        <div class="form-group col-12 col-md-6 col-lg-3 m-b-40">
                            <div class="input-group">
                                <input type="text" class="form-control font-14 text-center" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off"/>
                                <span class="input-group-text bg-gris">al</span>
                                <input type="text" class="form-control font-14 text-center" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off"/>
                            </div>
                            <label>Rango de fechas</label>
                        </div>
                        <div class="form-group col-12 col-md-6 col-lg-3 m-b-40">
                            <select class="selectpicker form-control" name="filtro_proveedor" id="filtro_proveedor" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                <option value="%" active>Mostrar Todo</option>
                                <optgroup>
                                    <?php foreach($this->Proveedor as $key => $value): ?>
                                        <option value="<?php echo $value['id_prov']; ?>"><?php echo (($value['ruc'] == '')? $value['dni'] : $value['ruc']).' - '.$value['razon_social']; ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                            <span class="bar"></span>
                            <label for="filtro_proveedor">Proveedor</label>
                        </div>
                        <div class="form-group col-12 col-md-4 col-lg-2 m-b-40">
                            <select class="selectpicker form-control" name="filtro_tipo" id="filtro_tipo" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                <option value="%" active>Mostrar Todo</option>
                                <optgroup>
                                    <option value="1">CONTADO</option>
                                    <option value="2">CREDITO</option>
                                </optgroup>
                            </select>
                            <span class="bar"></span>
                            <label for="filtro_tipo">Tipo Pago</label>
                        </div>              
                        <div class="form-group col-12 col-md-4 col-lg-2 m-b-40">
                            <select class="selectpicker form-control" name="filtro_documento" id="filtro_documento" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                <option value="%" active>Mostrar Todo</option>
                                <optgroup>
                                    <option value="1">BOLETA</option>
                                    <option value="2">FACTURA</option>
                                    <option value="3">NOTA DE ENTRADA</option>
                                </optgroup>
                            </select>
                            <span class="bar"></span>
                            <label for="filtro_documento">Tipo Comprobante</label>
                        </div>  
                        <div class="form-group col-12 col-md-4 col-lg-2 m-b-40">
                            <select class="selectpicker form-control" name="filtro_estado" id="filtro_estado" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                <option value="%" active>Mostrar Todo</option>
                                <optgroup>
                                    <option value="a">APROBADO</option>
                                    <option value="i">ANULADO</option>
                                </optgroup>
                            </select>
                            <span class="bar"></span>
                            <label for="filtro_estado">Estado</label>
                        </div>               
                    </div>
                </div>
            </div>
            <!-- INICIO SECCIÓN DE TOTALES REDISEÑADA -->
            <div class="card-body p-t-0">
                <div class="p-3 bg-light rounded">
                    <div class="row row-cols-1 row-cols-sm-2 g-3 text-center">
                        <div class="col">
                            <div class="card h-100 shadow-sm">
                                <div class="card-body d-flex flex-column justify-content-center">
                                    <h6 class="card-title text-muted text-uppercase small">Nº Operaciones</h6>
                                    <h3 class="font-weight-bold mb-0 compras-operaciones"></h3>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card h-100 shadow-sm bg-primary text-white">
                                <div class="card-body d-flex flex-column justify-content-center">
                                    <h6 class="card-title text-uppercase small">Total de Compras</h6>
                                    <h3 class="font-weight-bold mb-0 compras-total"></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- FIN SECCIÓN DE TOTALES REDISEÑADA -->
            <div class="card-body p-0">
                <div class="table-responsive b-t m-b-10">
                    <table id="table" class="table table-hover table-condensed stylish-table" width="100%">
                        <thead class="table-head">
                            <tr>
                                <th style="width:10%;">Fech.Reg.</th>
                                <th style="width:10%;">Fech.Doc.</th>
                                <th style="width:15%;">Documento</th>
                                <th style="width:25%;">Proveedor</th>
                                <th style="width:10%;" class="text-right">Total</th>
                                <th style="width:10%;" class="text-center">Tipo</th>
                                <th style="width:10%;" class="text-center">Estado</th>
                                <th style="width:10%;" class="text-right">Acciones</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-detalle" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInRight">
            <div class="modal-header">
                <h5 class="modal-title">Detalle</h5>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed m-b-0">
                        <thead class="table-head">
                            <tr>
                                <th>Código</th>
                                <th>Categoría</th>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>P.U.</th>
                                <th class="text-right">Importe</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="list-cetalle"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-detalle-cuota" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInRight">
            <div class="modal-header">
                <h5 class="modal-title title-d">Detalle</h5>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body p-0">
                <table class="table table-hover table-condensed m-b-0">
                    <thead class="table-head">
                        <tr>
                            <th>Fecha</th>
                            <th>Interes</th>
                            <th class="text-right">Importe</th>
                            <th class="text-center">Estado</th>
                            <th class="text-right">Opciones</th>
                        </tr>
                    </thead>
                    <tbody class="tb-st" id="list-cuota"></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-detalle-sub-cuota" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInRight">
            <div class="modal-header">
                <h5 class="modal-title title-d">Detalle</h5>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body p-0">
                <table class="table table-hover table-condensed m-b-0">
                    <thead class="table-head">
                        <tr>
                            <th>Cajero</th>
                            <th>Fecha/Hora</th>
                            <th>Egreso Caja</th>
                            <th class="text-right">Importe</th>
                        </tr>
                    </thead>
                    <tbody class="tb-st" id="list-sub-cuota"></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Atrás</button>
            </div>
        </div>
    </div>
</div>