<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<div class="row page-titles">
    <div class="col-md-12 align-self-center">
        <h4 class="m-b-0 m-t-0">Informes</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>informe" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>informe" class="link">Informe de ventas</a></li>
            <li class="breadcrumb-item active">Kardex de productos por ventas</li>
        </ol>
    </div>
</div>

<!--This page css - Morris CSS -->
<link href="<?php echo URL; ?>public/plugins/morrisjs/morris.css" rel="stylesheet">
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <form>
            <div class="card-body p-b-0">
                <div class="message-box contact-box">
                    <div class="d-flex align-items-center mb-3">
                        <!-- Botón de exportar alineado a la derecha, sin título de filtros -->
                        <div class="ml-auto">
                            <div class="btn-group">
                            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-download mr-1"></i> Exportar
                            </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a class="dropdown-item" href="javascript:void();" id="excel"><i class="far fa-file-excel text-success mr-2"></i>A Excel</a>
                                    <a class="dropdown-item" href="javascript:void();" id="pdf"><i class="far fa-file-pdf text-danger mr-2"></i>A PDF</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row floating-labels">
                        <div class="col-12 col-lg-3">
                            <div class="form-group m-b-40">
                                <div class="input-group">
                                    <input type="text" class="form-control font-14 text-center" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off"/>
                                    <span class="input-group-text bg-gris">al</span>
                                    <input type="text" class="form-control font-14 text-center" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off"/>
                                </div>
                                <label>Rango de fechas</label>
                            </div>
                        </div>
                        <div class="col-12 col-md-4 col-lg-2">
                            <div class="form-group m-b-40">
                                <select class="selectpicker form-control" name="filtro_categoria" id="filtro_categoria" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                    <option value="%" active>Seleccionar</option>
                                    <optgroup>
                                        <?php foreach($this->Categoria as $key => $value): ?>
                                            <option value="<?php echo $value['id_catg']; ?>"><?php echo $value['descripcion']; ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                </select>
                                <span class="bar"></span>
                                <label for="filtro_categoria">Categoría</label>
                            </div>
                        </div>
                        <div class="col-12 col-md-8 col-lg-4">
                            <div class="form-group m-b-40">
                                <select class="selectpicker form-control" name="filtro_producto" id="filtro_producto" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5" disabled>
                                    <option value="%" active>Seleccionar</option>
                                    <optgroup>
                                        <?php foreach($this->Producto as $key => $value): ?>
                                            <option value="<?php echo $value['id_prod']; ?>"><?php echo $value['nombre']; ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                </select>
                                <span class="bar"></span>
                                <label for="filtro_producto">Producto</label>
                            </div>
                        </div>
                        <div class="col-12 col-lg-3">
                            <div class="form-group m-b-40">
                                <select class="selectpicker form-control" name="filtro_presentacion" id="filtro_presentacion" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5" disabled>
                                    <option value="%" active>Seleccionar</option>
                                    <optgroup>
                                        <?php foreach($this->Presentacion as $key => $value): ?>
                                            <option value="<?php echo $value['id_pres']; ?>"><?php echo $value['presentacion']; ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                </select>
                                <span class="bar"></span>
                                <label for="filtro_presentacion">Presentación</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
            <!-- INICIO SECCIÓN DE TOTALES REDISEÑADA -->
            <div class="card-body p-t-0">
                <div class="p-3 bg-light rounded">
                    <div class="row row-cols-1 row-cols-sm-2 g-3 text-center">
                        <div class="col">
                            <div class="card h-100 shadow-sm">
                                <div class="card-body d-flex flex-column justify-content-center">
                                    <h6 class="card-title text-muted text-uppercase small">Cantidad Vendida</h6>
                                    <h3 class="font-weight-bold mb-0 productos-operaciones"></h3>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card h-100 shadow-sm bg-primary text-white">
                                <div class="card-body d-flex flex-column justify-content-center">
                                    <h6 class="card-title text-uppercase small">Total de Ventas</h6>
                                    <h3 class="font-weight-bold mb-0 productos-total"></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- FIN SECCIÓN DE TOTALES REDISEÑADA -->
            
            <!-- INICIO SECCIÓN DEL GRÁFICO -->
            <div class="card-body">
                 <h4 class="card-title">Gráfico de Ventas</h4>
                 <hr>
                 <div id="chart-ventas-productos"></div>
            </div>
            <!-- FIN SECCIÓN DEL GRÁFICO -->

            <div class="card-body p-0">
                <div class="table-responsive b-t m-b-10">
                    <table id="table" class="table table-hover table-condensed stylish-table" width="100%">
                        <thead class="table-head">
                            <tr>
                                <th width="10%">Fecha</th>
                                <th width="15%">Documento</th>
                                <th width="10%">Nº doc</th>
                                <th width="25%">Producto</th>
                                <th width="10%">Categoría</th>
                                <th class="text-right" width="10%">Cantidad vendida</th>
                                <th class="text-right" width="10%">P.V.</th>
                                <th class="text-right" width="10%">Total</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>