document.addEventListener("DOMContentLoaded", () => {
    // --- URLs Y CONSTANTES ---
    const API_EMPRESA = 'https://pale2.tufacturaya.com/restaurantepro/pedidos2/carta/Database/DataEmpresa.php';
    const API_PRODUCTOS = 'https://pale2.tufacturaya.com/restaurantepro/pedidos2/carta/Database/DataBase.php';
    const LOGO_URL_BASE = 'https://pale2.tufacturaya.com/restaurantepro/facturacion/public/images/';
    const Img_URL = 'https://pale2.tufacturaya.com/restaurantepro/facturacion/public/images/productos/';
    
    // --- SELECTORES DEL DOM ---
    const logoNav = document.getElementById("logo-nav"),
          nombreNav = document.getElementById("nombre-nav"),
          logoFooter = document.getElementById("logo-footer"),
          nombreFooter = document.getElementById("nombre-footer"),
          contactosFooter = document.getElementById("contactos-footer"),
          mapContainer = document.getElementById("map-container"),
          contenedorPopulares = document.querySelector("#contenedor-populares"),
          heroTitle = document.getElementById("hero-title");

    // --- FUNCIONES DE CARGA DE DATOS ---
    async function cargarDatosEmpresa() {
        try {
            const response = await fetch(API_EMPRESA);
            if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
            const data = await response.json();
            if (data && data.length > 0) {
                const empresa = data[0];
                const nombreComercial = empresa.nombre_comercial || "Nombre no disponible";
                document.title = `${nombreComercial} - Sabor que Une`;
                if (empresa.logo) {
                    const logoUrl = LOGO_URL_BASE + empresa.logo;
                    if (logoNav) { logoNav.src = logoUrl; logoNav.style.display = 'inline-block'; if (nombreNav) nombreNav.style.display = 'none'; }
                    if (logoFooter) { logoFooter.src = logoUrl; logoFooter.style.display = 'block'; if (nombreFooter) nombreFooter.style.display = 'none'; }
                } else {
                    if (nombreNav) nombreNav.innerText = nombreComercial;
                    if (nombreFooter) nombreFooter.innerText = nombreComercial;
                }
                if (heroTitle) { heroTitle.innerHTML = `El Aut&eacute;ntico Sabor de <br>${nombreComercial}`; }
                if(contactosFooter) { contactosFooter.innerHTML = `<li><i class="bi bi-geo-alt-fill me-2"></i> ${empresa.direccion_comercial || 'Direccin no disponible'}</li><li><i class="bi bi-telephone-fill me-2"></i> ${empresa.celular || 'Telfono no disponible'}</li><li><i class="bi bi-envelope-fill me-2"></i> ${empresa.email || 'Email no disponible'}</li>`; }
                if (empresa.direccion_comercial && mapContainer) { const direccionCodificada = encodeURIComponent(empresa.direccion_comercial); mapContainer.innerHTML = `<iframe src="https://maps.google.com/maps?q=${direccionCodificada}&t=&z=15&ieUTF8&iwloc=&output=embed" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>`; }
                else if (mapContainer) { mapContainer.innerHTML = `<p class="text-center text-muted">Ubicacin no disponible.</p>`; }
                const btnReserva = document.getElementById("btn-reserva-whatsapp");
                if (btnReserva && empresa.celular) { const numeroLimpio = empresa.celular.replace(/\D/g, ''); const numeroWhatsapp = `51${numeroLimpio}`; btnReserva.href = `https://wa.me/${numeroWhatsapp}?text=Hola,%20quisiera%20hacer%20una%20reserva.`; }
            }
        } catch (error) { console.error("Error al cargar datos de la empresa:", error); if(contactosFooter) contactosFooter.innerHTML = `<li>Error al cargar la informacin.</li>`; }
    }
    async function cargarPopulares() {
        try {
            const response = await fetch(API_PRODUCTOS);
            if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
            let productos = await response.json();
            if (productos && productos.length > 0 && contenedorPopulares) {
                contenedorPopulares.innerHTML = "";
                const populares = productos.slice(0, 6);
                populares.forEach(producto => {
                    const slide = document.createElement("div");
                    slide.className = "swiper-slide";
                    slide.innerHTML = `<div class="card popular-card h-100"><img src="${Img_URL + producto.archivo_imagen}" class="popular-card-img" alt="${producto.presentacion}"><div class="popular-card-body"><h5 class="popular-card-title">${producto.presentacion}</h5><div class="d-flex justify-content-between align-items-center mt-2"><p class="popular-card-price mb-0">S/ ${parseFloat(producto.precio).toFixed(2)}</p><a href="menu.html" class="popular-card-btn"><i class="bi bi-arrow-right"></i></a></div></div></div>`;
                    contenedorPopulares.appendChild(slide);
                });
                new Swiper('.populares-swiper', { slidesPerView: 1, spaceBetween: 30, navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' }, breakpoints: { 768: { slidesPerView: 2 }, 1200: { slidesPerView: 3 } } });
            } else if (contenedorPopulares) { contenedorPopulares.innerHTML = `<p>No hay productos populares.</p>`; }
        } catch (error) { console.error("Error al cargar populares:", error); if(contenedorPopulares) contenedorPopulares.innerHTML = `<div class="alert alert-danger">No se pudieron cargar los platos populares.</div>`; }
    }

    // --- EJECUCI07N ---
    cargarDatosEmpresa();
    cargarPopulares();
});