<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, #1bc943 0%, #0ea332 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MEJORADO === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    /* overflow: hidden; */
}

/* === BOTÓN CIRCULAR MODERNO === */
.btn-add-modern {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--success-color) 0%, #0ea332 100%);
    border: none;
    box-shadow: 0 4px 15px rgba(27, 201, 67, 0.4);
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-add-modern:hover {
    transform: translateY(-3px) scale(1.05);
    box-shadow: 0 6px 20px rgba(27, 201, 67, 0.5);
}

.btn-add-modern i {
    font-size: 1.5rem;
    color: white;
}

/* === TARJETAS DE ESTADÍSTICAS === */
.stats-container-inline {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.stat-card-inline {
    background: white;
    border-radius: 10px;
    padding: 1.25rem;
    text-align: center;
    border-left: 4px solid var(--success-color);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.stat-card-inline::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 80px;
    height: 80px;
    background: var(--success-color);
    opacity: 0.05;
    border-radius: 50%;
    transform: translate(30%, -30%);
}

.stat-card-inline:hover {
    transform: translateY(-3px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.stat-value-inline {
    font-size: 1.75rem;
    font-weight: 700;
    color: var(--success-color);
    margin-bottom: 0.25rem;
}

.stat-label-inline {
    font-size: 0.8125rem;
    font-weight: 500;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* === FILTROS === */
.filters-section {
    display: grid;
    grid-template-columns: 1fr 2fr;
    gap: 1rem;
    margin-bottom: 1rem;
}

.form-group-modern {
    position: relative;
}

.form-group-modern label {
    font-size: 0.875rem;
    font-weight: 500;
    color: #495057;
}

/* === ESTILOS PARA SELECT Y INPUTS === */
.form-control, 
.selectpicker,
.bootstrap-select .btn {
    border: 1.5px solid #ced4da !important;
    border-radius: 8px !important;
    transition: var(--transition);
}

.form-control:focus,
.bootstrap-select.open .btn {
    border-color: var(--success-color) !important;
    box-shadow: 0 0 0 0.2rem rgba(27, 201, 67, 0.15) !important;
}

.bootstrap-select .dropdown-toggle {
    background: white !important;
    border: 1.5px solid #ced4da !important;
}

.bootstrap-select .dropdown-toggle:hover {
    border-color: var(--success-color) !important;
}

/* === TABLA MEJORADA === */
.table-modern thead {
    background: linear-gradient(135deg, #1bc943 0%, #0ea332 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === MODAL MODERNO === */
.modal-content-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, #1bc943 0%, #0ea332 100%);
    color: white;
    border: none;
    border-radius: var(--border-radius) var(--border-radius) 0 0;
    padding: 1.5rem;
}

.modal-header-modern .modal-title {
    font-weight: 600;
    color: white;
}

.modal-header-modern .close {
    color: white;
    opacity: 0.9;
    text-shadow: none;
}

.modal-header-modern .close:hover {
    opacity: 1;
}

.modal-body-modern {
    padding: 2rem;
}

.modal-footer-modern {
    border: none;
    padding: 1.5rem;
    background: var(--light-bg);
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === RESPONSIVE === */
@media (max-width: 768px) {
    .page-titles-modern {
        padding: 1.5rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.5rem;
    }
    
    .stats-container-inline {
        gap: 0.75rem;
    }
    
    .stat-value-inline {
        font-size: 1.5rem;
    }
    
    .filters-section {
        grid-template-columns: 1fr;
    }
    
    .table-modern thead th,
    .table-modern tbody td {
        padding: 0.75rem 0.5rem;
        font-size: 0.875rem;
    }
}

@media (max-width: 576px) {
    .page-titles-modern {
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.25rem;
    }
    
    .breadcrumb-modern {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
    }
    
    .stat-card-inline {
        padding: 1rem;
    }
    
    .stat-value-inline {
        font-size: 1.25rem;
    }
    
    .stat-label-inline {
        font-size: 0.7rem;
    }
    
    .btn-add-modern {
        width: 50px;
        height: 50px;
    }
    
    .btn-add-modern i {
        font-size: 1.25rem;
    }
}

/* === SCROLLBAR === */
.table-responsive::-webkit-scrollbar {
    height: 8px;
}

.table-responsive::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.table-responsive::-webkit-scrollbar-thumb {
    background: var(--success-color);
    border-radius: 10px;
}

.table-responsive::-webkit-scrollbar-thumb:hover {
    background: #0ea332;
}
</style>

<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<input type="hidden" id="cod_ape" value="<?php echo Session::get('aperturaIn'); ?>"/>
<input type="hidden" id="rol_usr" value="<?php echo Session::get('rol'); ?>"/>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>

<!-- HEADER MODERNO -->
<div class="page-titles-modern animate-in">
    <h4><i class="ti-arrow-up mr-2"></i>Ingresos Administrativos</h4>
    <div class="breadcrumb-modern">
        <span class="breadcrumb-item"><a href="<?php echo URL; ?>caja/ingreso"><i class="fa fa-home mr-1"></i>Inicio</a></span>
        <span class="breadcrumb-item">/</span>
        <span class="breadcrumb-item active">Ingresos</span>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card card-modern animate-in">         

            <div class="card-body p-0">
                <div class="row m-t-20 px-3">
                    <div class="col-lg-4 col-md-12 mb-3">
                        <button type="button" class="btn btn-success btn-block mb-3 shadow-sm font-weight-bold p-3" data-toggle="modal" data-target="#modal" style="border-radius: 10px; font-size: 1.1rem;">
                            <i class="fa fa-plus-circle mr-2"></i>NUEVO INGRESO
                        </button>
                        <div class="stats-container-inline">
                            <div class="stat-card-inline">
                                <div class="stat-value-inline ingresos-total">S/ 0.00</div>
                                <div class="stat-label-inline">Total</div>
                            </div>
                            <div class="stat-card-inline">
                                <div class="stat-value-inline ingresos-oper">0</div>
                                <div class="stat-label-inline">Operaciones</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-12">
                        <div class="filters-section">
                            <div class="form-group-modern m-b-40">
                                <select class="selectpicker form-control" name="filtro_estado" id="filtro_estado" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                    <option value="%" active>Mostrar Todo</option>
                                    <optgroup>
                                        <option value="a">APROBADO</option>
                                        <option value="i">ANULADO</option>
                                    </optgroup>
                                </select>
                                <span class="bar"></span>
                                <label for="filtro_estado"><i class="fa fa-filter mr-1"></i>Estado</label>
                            </div>
                            <div class="form-group-modern m-b-20">
                                <input type="text" class="form-control global_filter" id="global_filter" autocomplete="off" placeholder="Buscar...">
                                <span class="bar"></span>
                                <label for="global_filter"><i class="fa fa-search mr-1"></i>Búsqueda</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive b-t m-b-10">
                    <table id="table" class="table table-modern table-hover table-condensed stylish-table" cellspacing="0" width="100%">
                        <thead>
                            <th>Fecha</th>
                            <th>Hora</th>
                            <th>Recibido de</th>
                            <th>Motivo</th>
                            <th>Importe</th>
                            <th class="text-center">Estado</th>
                            <th class="text-right">Acciones</th>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL MODERNO -->
<div class="modal inmodal" id="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content modal-content-modern">
        <form id="form" method="post" enctype="multipart/form-data">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"><i class="fa fa-plus-circle mr-2"></i>Ingreso Administrativo</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 dec">
                            <input type="text" class="form-control" name="importe" id="importe" autocomplete="off" required="required"/>
                            <span class="bar"></span>
                            <label for="importe"><i class="fa fa-dollar mr-1"></i>Importe - <?php echo Session::get('moneda'); ?></label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <input name="responsable" id="responsable" class="form-control input-mayus" autocomplete="off" required="required"/>
                            <span class="bar"></span>
                            <label for="responsable"><i class="fa fa-user mr-1"></i>Recibido de</label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <textarea name="motivo" id="motivo" class="form-control" rows="3" required="required"></textarea>
                            <span class="bar"></span>
                            <label for="motivo"><i class="fa fa-comment-o mr-1"></i>Motivo</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fa fa-times mr-1"></i>Cancelar
                </button>
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-check mr-1"></i>Aceptar
                </button>
            </div>
        </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const animateElements = document.querySelectorAll('.animate-in');
    animateElements.forEach((el, index) => {
        el.style.animationDelay = `${index * 0.1}s`;
    });
});
</script>
