<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<style>
/* === VARIABLES CSS (Extract from monitor.php) === */

:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === TARJETAS DE ESTADÍSTICAS === */
.stats-container {
    display: grid;
    /* DESKTOP DEFAULT: Intentar 5 por fila si caben */
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1rem;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    border-left: 4px solid;
    position: relative;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    justify-content: center;
    min-height: 90px;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 60px;
    height: 60px;
    background: currentColor;
    opacity: 0.05;
    border-radius: 50%;
    transform: translate(30%, -30%);
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: var(--card-shadow-hover);
}

.stat-card.stat-primary { border-left-color: var(--primary-color); color: var(--primary-color); }
.stat-card.stat-success { border-left-color: var(--success-color); color: var(--success-color); }
.stat-card.stat-warning { border-left-color: var(--warning-color); color: var(--warning-color); }
.stat-card.stat-danger { border-left-color: var(--danger-color); color: var(--danger-color); }
.stat-card.stat-info { border-left-color: var(--info-color); color: var(--info-color); }
.stat-card.stat-dark { border-left-color: var(--dark-color); color: var(--dark-color); }

.stat-icon {
    font-size: 1.8rem;
    opacity: 0.15;
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
}

.stat-value {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 0.1rem;
    position: relative;
    z-index: 1;
    line-height: 1.2;
}

.stat-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    position: relative;
    z-index: 1;
}

/* === FILTROS MEJORADOS === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.25rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 1.5rem;
}

.filter-section {
    display: grid;
    /* Ajuste para que los filtros se acomoden mejor */
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 1rem;
    margin-bottom: 0;
    align-items: end;
}

.form-group-modern {
    position: relative;
    margin-bottom: 0;
}

.form-group-modern label {
    font-size: 0.8rem;
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.4rem;
    display: block;
}

.input-group-dates {
    display: flex;
    gap: 0; 
    align-items: center;
    border: 1.5px solid #ced4da;
    border-radius: 8px;
    overflow: hidden;
}

.input-group-dates .form-control {
    flex: 1;
    border: none !important;
    border-radius: 0 !important;
    font-size: 0.85rem;
    padding: 0.4rem 0.2rem;
    text-align: center;
}

.input-group-dates .input-group-text {
    background: var(--light-bg);
    border: none;
    border-left: 1px solid #dee2e6;
    border-right: 1px solid #dee2e6;
    color: #6c757d;
    font-weight: 500;
    padding: 0.4rem 0.6rem;
    font-size: 0.8rem;
    border-radius: 0;
}

/* === ESTILOS PARA SELECT Y INPUTS === */
.form-control, 
.selectpicker,
.bootstrap-select .btn {
    border: 1.5px solid #ced4da !important;
    border-radius: 8px !important;
    transition: var(--transition);
    font-size: 0.9rem !important;
    padding: 0.4rem 0.8rem !important;
    height: auto !important;
    min-height: 38px;
}

.form-control:focus,
.bootstrap-select.open .btn {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 0.2rem rgba(86, 100, 210, 0.15) !important;
}

.bootstrap-select .dropdown-toggle {
    background: white !important;
    border: 1.5px solid #ced4da !important;
}

/* === TABLA RESPONSIVE === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
    min-height: 400px;
}

.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    margin-bottom: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 0.8rem 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

.table-modern tbody td {
    padding: 0.8rem 1rem;
    vertical-align: middle;
    font-size: 0.9rem;
}

/* === RESPONSIVE MODIFICATIONS === */
@media (max-width: 768px) {
    .stats-container {
        /* Mobile: FORCE 2 COLUMNS */
        grid-template-columns: repeat(2, 1fr) !important;
        gap: 0.75rem;
    }
    
    .stat-card {
        padding: 0.75rem;
        min-height: 80px;
    }
    
    .stat-value {
        font-size: 1.1rem;
    }
    
    .stat-label {
        font-size: 0.65rem;
    }

    .stat-icon {
        font-size: 1.5rem;
    }

    .filter-section {
        grid-template-columns: 1fr; /* Stack filters on mobile */
    }
    
    .btn-export-block {
        width: 100%;
    }
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === MODALES MODERNOS === */
.modal-content-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
    border: none;
    border-radius: var(--border-radius) var(--border-radius) 0 0;
    padding: 1rem 1.5rem;
}

.modal-title { font-size: 1.1rem; }

.modal-body-modern {
    padding: 1.5rem;
}

.modal-footer-modern {
    border: none;
    padding: 1rem 1.5rem;
    background: var(--light-bg);
    border-radius: 0 0 var(--border-radius) var(--border-radius);
}
</style>

<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<input type="hidden" id="igv" value="<?php echo igv_dec; ?>"/>
<input type="hidden" id="igv2" value="<?php echo igv_dec2; ?>"/>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="cod_rol_usu" value="<?php echo Session::get('rol'); ?>"/>
<input type="hidden" id="usuid" value="<?php echo Session::get('usuid'); ?>"/>
<input type="hidden" id="entorno" value="<?php echo ROOT_UBL21.Session::get('ruc'); ?>"/>
<input type="hidden" id="api_wsp" value="<?php echo Session::get('api_wsp'); ?>"/>
<input type="hidden" id="mesaje_waz" value="Su comprobante de pago electrónico ha sido generado correctamente, puede revisarlo en el siguiente enlace:"/>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <h4><i class="fas fa-file-invoice mr-2"></i>Facturaci&oacute;n Electr&oacute;nica</h4>
    <div class="breadcrumb-modern">
        <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Facturación</span>
        <span class="breadcrumb-item">/</span>
        <span class="breadcrumb-item active">Gestión de Comprobantes</span>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card" style="border: none; border-radius: var(--border-radius); box-shadow: var(--card-shadow);">
            <div class="card-body p-0">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs nav-tabs-modern" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#tab1" role="tab">
                            <i class="fas fa-file-invoice-dollar mr-2"></i>
                            <span class="hidden-sm-up">CP</span>
                            <span class="hidden-xs-down">Comprobantes</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#tab2" role="tab">
                            <i class="fas fa-trash-alt mr-2"></i>
                            <span class="hidden-sm-up">BF</span>
                            <span class="hidden-xs-down">Baja Facturas</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#tab3" role="tab">
                            <i class="fas fa-trash mr-2"></i>
                            <span class="hidden-sm-up">BB</span>
                            <span class="hidden-xs-down">Baja Boletas</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#tab4" role="tab">
                            <i class="fas fa-list-alt mr-2"></i>
                            <span class="hidden-sm-up">RC</span>
                            <span class="hidden-xs-down">Resumen de Boletas</span>
                        </a>
                    </li>
                </ul>
            
                <!-- Tab panes -->
                <div class="tab-content" style="padding: 1.5rem;">
                    
                    <!-- TAB 1: COMPROBANTES -->
                    <div class="tab-pane active" id="tab1" role="tabpanel">
                        <!-- FILTROS -->
                        <div class="filters-card animate-in">
                            <div class="filter-section">
                                <div class="form-group-modern" style="grid-column: span 1.5;">
                                    <label><i class="fas fa-calendar-alt mr-1"></i>Rango de fechas</label>
                                    <div class="input-group-dates">
                                        <input type="text" class="form-control" name="start-1" id="start-1" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Inicio"/>
                                        <span class="input-group-text"><i class="fas fa-arrow-right" style="font-size: 0.7rem;"></i></span>
                                        <input type="text" class="form-control" name="end-1" id="end-1" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
                                    </div>
                                </div>
                                <div class="form-group-modern">
                                    <label><i class="fas fa-hashtag mr-1"></i>Nº CPE</label>
                                    <input class="form-control" name="input_num" id="input_num" placeholder="000" />
                                </div>
                                <div class="form-group-modern">
                                    <label><i class="fas fa-file-alt mr-1"></i>Tipo</label>
                                    <select class="selectpicker form-control" name="tipo_doc" id="tipo_doc" title="Tipo" data-style="btn-default">
                                        <option value="%" selected>Todo</option>
                                        <option value="1">BOLETA</option>
                                        <option value="2">FACTURA</option>
                                    </select>
                                </div>
                                <div class="form-group-modern" style="grid-column: span 1.5;">
                                    <label><i class="fas fa-user mr-1"></i>Cliente</label>
                                    <input type="text" class="form-control buscar_cliente" name="buscar_cliente" id="buscar_cliente" placeholder="Buscar Cliente..." autocomplete="off">
                                    <input type="hidden" name="cliente_id" id="cliente_id" value="%">
                                </div>
                                <div class="form-group-modern">
                                    <label><i class="fas fa-info-circle mr-1"></i>Estado</label>
                                    <select class="selectpicker form-control" name="est_doc" id="est_doc" title="Estado" data-style="btn-default">
                                        <option value="%" selected>Todo</option>
                                        <option value="1">ENVIADO</option>
                                        <option value="2">PENDIENTE</option>
                                        <option value="3">ANULADO</option>
                                        <?php if(Session::get('usuid')=='1'){?>
                                            <option value="10">SIN CDR</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group-modern d-flex align-items-end">
                                    <div class="btn-group shadow-sm btn-export-block">
                                        <button type="button" class="btn btn-primary dropdown-toggle pt-2 pb-2 pl-3 pr-3" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-download"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item" href="javascript:void(0);" id="excel"><i class="fas fa-file-excel mr-2 text-success"></i> Excel</a>
                                            <a class="dropdown-item" href="javascript:void(0);" id="pdf"><i class="fas fa-file-pdf mr-2 text-danger"></i> PDF</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ESTADISTICAS -->
                        <div class="stats-container animate-in">
                            <div class="stat-card stat-success">
                                <i class="fas fa-check-circle stat-icon"></i>
                                <div class="stat-value" id="total_enviados">0</div>
                                <div class="stat-label">Enviados</div>
                            </div>
                            <div class="stat-card stat-warning">
                                <i class="fas fa-exclamation-circle stat-icon"></i>
                                <div class="stat-value" id="total_noenviados">0</div>
                                <div class="stat-label">Pendientes</div>
                            </div>
                            <div class="stat-card stat-info">
                                <i class="fas fa-file-invoice stat-icon"></i>
                                <div class="stat-value" id="total_facturas">0</div>
                                <div class="stat-label">Total Facturas</div>
                            </div>
                            <div class="stat-card stat-primary">
                                <i class="fas fa-receipt stat-icon"></i>
                                <div class="stat-value" id="total_boletas">0</div>
                                <div class="stat-label">Total Boletas</div>
                            </div>
                            <div class="stat-card stat-danger">
                                <i class="fas fa-ban stat-icon"></i>
                                <div class="stat-value" id="total_anulados">0</div>
                                <div class="stat-label">Anulados</div>
                            </div>
                        </div>

                        <!-- TOTALES MONETARIOS -->
                        <div class="stats-container animate-in">
                            <div class="stat-card stat-dark">
                                <i class="fas fa-coins stat-icon"></i>
                                <div class="stat-value" id="totalMontoBoleta" style="font-size: 1.15rem;">0.00</div>
                                <div class="stat-label">Monto Boletas</div>
                            </div>
                            <div class="stat-card stat-dark">
                                <i class="fas fa-money-bill-wave stat-icon"></i>
                                <div class="stat-value" id="totalMontoFactura" style="font-size: 1.15rem;">0.00</div>
                                <div class="stat-label">Monto Facturas</div>
                            </div>
                            <div class="stat-card stat-danger">
                                <i class="fas fa-times-circle stat-icon"></i>
                                <div class="stat-value" id="totalMontoAnulados" style="font-size: 1.15rem;">0.00</div>
                                <div class="stat-label">Monto Anulados</div>
                            </div>
                            <div class="stat-card stat-success">
                                <i class="fas fa-chart-line stat-icon"></i>
                                <div class="stat-value" id="totalMontoTotal" style="font-size: 1.15rem;">0.00</div>
                                <div class="stat-label">Total General</div>
                            </div>
                        </div>

                        <!-- TABLE -->
                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-1" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="4%">ID</th>
                                            <th width="8%">Fecha</th>
                                            <th width="10%">Comprobante</th>
                                            <th width="25%">Cliente</th>
                                            <th width="8%">Total</th>
                                            <th width="10%">Estado</th>
                                            <th width="4%">XML</th>
                                            <th width="4%">CDR</th>
                                            <th width="4%">PDF</th>
                                            <th width="5%">IMP.</th>
                                            <th width="4%">CORREO</th>
                                            <th width="4%">WHATSAPP</th>
                                            <th width="4%">SUNAT</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 2: BAJA FACTURAS -->
                    <div class="tab-pane" id="tab2" role="tabpanel">
                        <div class="filters-card animate-in">
                            <div class="filter-section">
                                <div class="form-group-modern" style="grid-column: span 1;">
                                    <label><i class="fas fa-calendar-alt mr-1"></i>Rango de fechas</label>
                                    <div class="input-group-dates">
                                        <input type="text" class="form-control" name="start-2" id="start-2" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off"/>
                                        <span class="input-group-text"><i class="fas fa-arrow-right" style="font-size: 0.7rem;"></i></span>
                                        <input type="text" class="form-control" name="end-2" id="end-2" value="<?php echo $fecha; ?>" autocomplete="off"/>
                                    </div>
                                </div>
                                <div class="form-group-modern d-flex align-items-end">
                                     <span id="btn-excel-02"></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-2" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="15%">Fecha Baja</th>
                                            <th width="10%">Correlativo</th>
                                            <th width="15%">Num.Doc</th>
                                            <th width="25%">Motivo</th>
                                            <th width="15%">Estado</th>
                                            <th width="5%">XML</th>
                                            <th width="5%">CDR</th>
                                            <th width="10%">Sunat</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 3: BAJA BOLETAS -->
                    <div class="tab-pane" id="tab3" role="tabpanel">
                        <div class="filters-card animate-in">
                            <div class="filter-section">
                                <div class="form-group-modern" style="grid-column: span 1;">
                                    <label><i class="fas fa-calendar-alt mr-1"></i>Rango de fechas</label>
                                    <div class="input-group-dates">
                                        <input type="text" class="form-control" name="start-3" id="start-3" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off"/>
                                        <span class="input-group-text"><i class="fas fa-arrow-right" style="font-size: 0.7rem;"></i></span>
                                        <input type="text" class="form-control" name="end-3" id="end-3" value="<?php echo $fecha; ?>" autocomplete="off"/>
                                    </div>
                                </div>
                                <div class="form-group-modern d-flex align-items-end">
                                     <span id="btn-excel-03"></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-3" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="20%">Fecha Baja</th>
                                            <th width="20%">Correlativo</th>
                                            <th width="20%">Num.Doc</th>
                                            <th width="20%">Estado</th>
                                            <th width="5%">XML</th>
                                            <th width="5%">CDR</th>
                                            <th width="10%">Sunat</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 4: RESUMEN BOLETAS -->
                    <div class="tab-pane" id="tab4" role="tabpanel">
                        <div class="filters-card animate-in">
                            <div class="filter-section">
                                <div class="form-group-modern" style="grid-column: span 1;">
                                    <label><i class="fas fa-calendar-alt mr-1"></i>Rango de fechas</label>
                                    <div class="input-group-dates">
                                        <input type="text" class="form-control" name="start-4" id="start-4" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off"/>
                                        <span class="input-group-text"><i class="fas fa-arrow-right" style="font-size: 0.7rem;"></i></span>
                                        <input type="text" class="form-control" name="end-4" id="end-4" value="<?php echo $fecha; ?>" autocomplete="off"/>
                                    </div>
                                </div>
                                <div class="form-group-modern d-flex align-items-end justify-content-between">
                                     <span id="btn-excel-04"></span>
                                     <button class="btn btn-success shadow-sm btn-nvo"><i class="fas fa-plus-circle mr-2"></i> Nuevo Resumen</button>
                                </div>
                            </div>
                        </div>

                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-4" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="15%">Fecha Resumen</th>
                                            <th width="15%">Fecha Documento</th>
                                            <th width="30%">Documentos</th>
                                            <th width="20%">Estado</th>
                                            <th width="5%">XML</th>
                                            <th width="5%">CDR</th>
                                            <th width="10%">Sunat</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL CREAR RESUMEN -->
<div class="modal inmodal" id="mdl-nvo-resumen" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"><i class="fas fa-list-alt mr-2"></i>Listar Comprobantes</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="alert alert-info shadow-sm mb-4" style="border-radius: 8px;">
                    <i class="fas fa-info-circle mr-2"></i> Seleccione la fecha de los documentos para generar el resumen diario.
                </div>
                <div class="form-group-modern mb-4">
                     <label>Fecha de Documentos:</label>
                     <input type="text" class="form-control font-14 text-center form-control-lg" name="fecha-rd" id="fecha-rd" value="<?php echo $fecha; ?>" autocomplete="off" style="border-radius: 8px;"/>
                </div>
                
                <h5 class="mb-3 font-weight-bold">Vista Previa</h5>
                <div class="table-responsive-modern border rounded" style="border-radius: 12px; overflow: hidden;">
                    <table id="table-5" class="table table-striped mb-0" width="100%">
                        <thead class="bg-light">
                            <tr>
                                <th width="20%">Fecha</th>
                                <th width="35%">Tipo</th>
                                <th width="15%">Serie</th>
                                <th width="15%">N&uacute;mero</th>
                                <th width="15%">Total</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-res shdow-sm"><i class="fas fa-check mr-2"></i>Crear Resumen</button>
            </div>
        </div>
    </div>
</div>

<!-- MODAL DETALLE -->
<div class="modal inmodal" id="mdl-detalle" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern bg-info">
                <h4 class="modal-title"><i class="fas fa-info-circle mr-2"></i>Detalle del Resumen</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body p-0">
                <div class="table-responsive-modern">
                    <table id="table-6" class="table table-modern table-striped m-0" width="100%">
                        <thead class="bg-light">
                            <tr>
                                <th width="15%">Fecha</th>
                                <th width="20%">Tipo</th>
                                <th width="15%">Serie-N&uacute;mero</th>
                                <th width="35%">Cliente</th>
                                <th class="text-right" width="15%">Total</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>