<?php Session::init(); if (Session::get('rol') == 1 OR Session::get('rol') == 2) { ?>
<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>

<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === DELICATE STATS CARDS (Reuse from Credit View) === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    display: flex;
    align-items: center;
    border-bottom: 4px solid transparent;
    transition: var(--transition);
}

.stat-card:hover { transform: translateY(-3px); }

.stat-icon-wrapper {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    margin-right: 1rem;
    flex-shrink: 0;
}

.stat-content {
    flex-grow: 1;
}

.stat-card h2 {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.2rem;
    color: #333;
}

.stat-card h6 {
    color: #888;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    margin: 0;
    font-weight: 500;
}

/* Variant Styles */
.stat-primary { border-bottom-color: var(--primary-color); }
.stat-primary .stat-icon-wrapper { background: rgba(86, 100, 210, 0.1); color: var(--primary-color); }
.stat-primary h2 { color: var(--primary-color); }

.stat-success { border-bottom-color: var(--success-color); }
.stat-success .stat-icon-wrapper { background: rgba(27, 201, 67, 0.1); color: var(--success-color); }
.stat-success h2 { color: var(--success-color); }

.stat-danger { border-bottom-color: var(--danger-color); }
.stat-danger .stat-icon-wrapper { background: rgba(231, 76, 60, 0.1); color: var(--danger-color); }
.stat-danger h2 { color: var(--danger-color); }

.stat-info { border-bottom-color: var(--info-color); }
.stat-info .stat-icon-wrapper { background: rgba(52, 152, 219, 0.1); color: var(--info-color); }
.stat-info h2 { color: var(--info-color); }

/* === FILTERS CARD === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.4rem;
    display: block;   
}

.input-group-modern {
    display: flex;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    overflow: hidden;
}

.input-group-modern .form-control {
    border: none;
    text-align: center;
}

.input-group-modern span {
    background: #f1f3f5;
    padding: 0.6rem 1rem;
    color: #666;
    font-size: 0.9rem;
    border-left: 1px solid #e0e0e0;
    border-right: 1px solid #e0e0e0;
    display: flex;
    align-items: center;
}

/* === TABLE MODERN === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
    border: 1px solid #f0f0f0;
}

.table-modern {
    width: 100%;
    margin-bottom: 0;
    border-collapse: separate;
    border-spacing: 0;
}

.table-modern thead th {
    background: #fff;
    color: #8898aa;
    font-weight: 600;
    font-size: 0.75rem;
    text-transform: uppercase;
    padding: 1rem;
    border-bottom: 1px solid #e9ecef;
    letter-spacing: 0.5px;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid #f6f9fc;
    font-size: 0.875rem;
    color: #525f7f;
}

.table-modern tbody tr:hover td {
    background-color: #f6f9fc;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-clipboard-list mr-2"></i>Kardex Valorizado</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Inventario</span>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item active">Reporte de Movimientos</span>
        </div>
    </div>
</div>

<!-- FILTERS -->
<div class="filters-card animate-in">
    <div class="row align-items-end">
        <div class="col-md-3">
             <div class="form-group-modern">
                <label><i class="far fa-calendar-alt mr-1"></i>Rango de Fechas</label>
                <div class="input-group-modern">
                    <input type="text" class="form-control" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off" placeholder="Inicio"/>
                    <span>al</span>
                    <input type="text" class="form-control" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
                </div>
            </div>
        </div>
        <div class="col-md-3">
             <div class="form-group-modern">
                <label><i class="fas fa-filter mr-1"></i>Tipo</label>
                <select class="selectpicker form-control" name="tipo_ip" id="tipo_ip" data-style="btn-white border" data-live-search="true" autocomplete="off" data-size="5">
                    <option value="1">INSUMO</option>
                    <option value="2">PRODUCTO</option>
                </select>
            </div>
        </div>
        <div class="col-md-6">
             <div class="form-group-modern">
                <label><i class="fas fa-box-open mr-1"></i>Producto / Insumo</label>
                <select class="selectpicker form-control" name="id_ip" id="id_ip" data-style="btn-white border" data-live-search="true" autocomplete="off" title="Seleccionar..." data-size="5">
                </select>
            </div>
        </div>
    </div>
</div>

<!-- STATS -->
<div class="stats-container animate-in">
    <div class="stat-card stat-primary">
        <div class="stat-icon-wrapper"><i class="fas fa-box"></i></div>
        <div class="stat-content">
            <h2 class="stock-inicial">0.0000</h2>
            <h6>Stock Inicial</h6>
        </div>
    </div>
    <div class="stat-card stat-success">
         <div class="stat-icon-wrapper"><i class="fas fa-arrow-circle-down"></i></div>
        <div class="stat-content">
            <h2 class="stock-entradas">0.0000</h2>
            <h6>Cant. Entradas</h6>
        </div>
    </div>
    <div class="stat-card stat-danger">
        <div class="stat-icon-wrapper"><i class="fas fa-arrow-circle-up"></i></div>
        <div class="stat-content">
            <h2 class="stock-salidas">0.0000</h2>
            <h6>Cant. Salidas</h6>
        </div>
    </div>
    <div class="stat-card stat-info">
        <div class="stat-icon-wrapper"><i class="fas fa-clipboard-check"></i></div>
        <div class="stat-content">
            <h2 class="stock-final">0.0000</h2>
            <h6>Stock Final</h6>
        </div>
    </div>
</div>

<!-- TABLE -->
<div class="table-card animate-in">
    <div class="table-responsive">
        <table id="table" class="table table-modern" width="100%">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 10%; vertical-align: middle; border-bottom: 2px solid #ddd !important;">Fecha</th>
                    <th rowspan="2" style="width: 25%; vertical-align: middle; border-bottom: 2px solid #ddd !important;">Concepto</th>
                    <th colspan="3" class="text-center text-success" style="border-bottom: 1px solid var(--success-color) !important;">Entrada</th>
                    <th colspan="3" class="text-center text-danger" style="border-bottom: 1px solid var(--danger-color) !important;">Salida</th>
                    <th colspan="3" class="text-center text-info" style="border-bottom: 1px solid var(--info-color) !important;">Saldo</th>
                </tr>
                <tr>
                    <th class="text-center text-success small">Cant.</th>
                    <th class="text-center text-success small">C.U.</th>
                    <th class="text-center text-success small">Total</th>
                    <th class="text-center text-danger small">Cant.</th>
                    <th class="text-center text-danger small">C.U.</th>
                    <th class="text-center text-danger small">Total</th>
                    <th class="text-center text-info small">Cant.</th>
                    <th class="text-center text-info small">C.U.</th>
                    <th class="text-center text-info small">Total</th>
                </tr>
            </thead>
            <tbody class="tb-st"></tbody>
        </table>
    </div>
</div>
<?php } ?>